/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.bridge;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.bridge.NativeBridge;
import com.ibm.hwmca.fw.net.LocalServerSocket;
import com.ibm.hwmca.fw.net.LocalSocket;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;

public class NativeBridgeServer {
    public static final String HMC_SOCKET_FILE = "NativeBridgeServer";
    LocalServerSocket serverSocket;
    boolean closed;

    public NativeBridgeServer() throws IOException, HException {
        String dir = BaseFileControl.getFilePath("domainsocket");
        new File(dir).mkdirs();
        this.initializeServer(dir + HMC_SOCKET_FILE);
    }

    public NativeBridgeServer(String path) throws IOException {
        this.initializeServer(path);
    }

    protected void initializeServer(String path) throws IOException {
        LocalServerSocket.removeSocket(path);
        this.serverSocket = new LocalServerSocket(path);
        Thread listenerThread = new Thread(new Runnable(){

            public void run() {
                NativeBridgeServer.this.acceptConnections();
            }
        }, "NativeBridgeServer listener on path: " + path);
        listenerThread.start();
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.serverSocket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptConnections() {
        while (true) {
            LocalSocket clientSocket = null;
            try {
                clientSocket = this.serverSocket.accept();
            }
            catch (IOException e) {
                NativeBridgeServer nativeBridgeServer = this;
                synchronized (nativeBridgeServer) {
                    if (this.closed) {
                        return;
                    }
                }
                System.err.println("Error accepting native bridge connection:");
                e.printStackTrace();
                System.err.println("Terminating native bridge connection listening");
                return;
            }
            try {
                new NativeBridge(clientSocket);
                continue;
            }
            catch (IOException e) {
                try {
                    clientSocket.close();
                }
                catch (IOException iOException) {
                }
                continue;
            }
            break;
        }
    }

    public static final class Init
    implements Runnable {
        public void run() {
            try {
                new NativeBridgeServer();
            }
            catch (Exception exc) {
                throw new UndeclaredThrowableException(exc);
            }
        }
    }
}

